# 容器操作

## 概念
启动容器有两种方式，一种是基于镜像新建一个容器并启动，另外一个是将在终止状态（stopped）的容器重新启动。

## 常见操作

```
# 新建并启动
$ docker run ubuntu:14.04 /bin/echo 'Hello world'

# 列出本机正在运行的容器
$ docker container ls

# 列出本机所有容器，包括终止运行的容器
$ docker container ls --all

# 生成一个正在运行的容器实例
$ docker container run
$ docker container run -it centos:latest bash

# 进入一个容器
$ docker attach [containerID]
$ docker exec -it <container> bash // 推荐使用

# 停止
$ docker container kill [containerID]

# 删除
$ docker container rm [containerID]
```

## 容器编排
Docker Compose
定义和运行多个 Docker 容器的应用

Swarm
可以轻松的管理和调度docker集群

## 注意
1. image 文件生成的容器实例，本身也是一个文件，称为容器文件。也就是说，一旦容器生成，就会同时存在两个文件： image文件和容器文件。而且关闭容器并不会删除容器文件，只是容器停止运行而已。